function f=obj_monod_final(var)
% objective: minizing the differences between observed and simulated growth
% kinetics
% Author: Xueyang Feng (fengx@seas.wustl.edu)
% date: 09/01/2011

TimeObs=[0;11;13;15;17;18;19;20;21;22;23.5000000000000;25;26.5000000000000;28;29.5000000000000;31;32.5000000000000;34;0;11;13;15;17;18;19;20;21;22;23.5000000000000;25;26.5000000000000;28;29.5000000000000;31;32.5000000000000;34;0;11;13;15;17;18;19;20;21;22;23.5000000000000;25;26.5000000000000;28;29.5000000000000;31;32.5000000000000;34;];
XObs=[0.000328030303030303;0.00984090909090909;0.0203378787878788;0.0183696969696970;0.0288666666666667;0.0531409090909091;0.0846318181818182;0.0833196969696970;0.0918484848484849;0.100377272727273;0.112842424242424;0.139740909090909;0.201410606060606;0.215187878787879;0.246678787878788;0.328030303030303;0.326718181818182;0.322125757575758;0.000328030303030303;0.0164015151515152;0.0249303030303030;0.0255863636363636;0.0321469696969697;0.0629818181818182;0.0649500000000000;0.0793833333333333;0.110218181818182;0.116122727272727;0.148269696969697;0.200098484848485;0.219780303030303;0.249959090909091;0.289978787878788;0.331966666666667;0.338527272727273;0.372642424242424;0.000328030303030303;0.0118090909090909;0.0229621212121212;0.0183696969696970;0.0314909090909091;0.0728227272727273;0.0715106060606061;0.0944727272727273;0.0997212121212121;0.0997212121212121;0.116778787878788;0.167295454545455;0.228309090909091;0.242086363636364;0.271609090909091;0.351648484848485;0.359521212121212;0.353616666666667;];
LACTObs=[30.3600000000000;27.8600000000000;26.0800000000000;25.3600000000000;25.3600000000000;22.8900000000000;20.7200000000000;20.2200000000000;18.5700000000000;16.2900000000000;13.4700000000000;8.08000000000000;2.79000000000000;0.110000000000000;0.110000000000000;0;0.0700000000000000;0.0700000000000000;29.2800000000000;26.4300000000000;26.4300000000000;24.2900000000000;21.7900000000000;19.5400000000000;18.5400000000000;18.0700000000000;21.5700000000000;12.9300000000000;9.12000000000000;3.33000000000000;0.180000000000000;0.110000000000000;0.110000000000000;0.0900000000000000;0;0;29.2900000000000;28.2200000000000;27.8600000000000;26.0700000000000;23.9300000000000;23.8900000000000;21.5700000000000;21;15.8600000000000;16.7600000000000;13.6900000000000;8.15000000000000;2.29000000000000;0.110000000000000;0.0400000000000000;0.0500000000000000;0.0500000000000000;0;];
ACTObs=[0.0200000000000000;0.270000000000000;0.480000000000000;0.790000000000000;1.19000000000000;1.12000000000000;1.31000000000000;1.75000000000000;2.11000000000000;2.72000000000000;3.48000000000000;4.56000000000000;6.44000000000000;7.57000000000000;7.81000000000000;6.99000000000000;3.83000000000000;0.970000000000000;0.0100000000000000;0.270000000000000;0.500000000000000;0.820000000000000;1.30000000000000;1.21000000000000;1.48000000000000;2.02000000000000;2.56000000000000;3.14000000000000;4.06000000000000;6.37000000000000;6.84000000000000;7.06000000000000;8.11000000000000;2.97000000000000;0.0700000000000000;0.0200000000000000;0.0200000000000000;0.280000000000000;0.510000000000000;0.870000000000000;1.33000000000000;1.22000000000000;1.39000000000000;1.93000000000000;2.12000000000000;2.89000000000000;3.74000000000000;5.20000000000000;7.05000000000000;8.03000000000000;6.13000000000000;6.91000000000000;3.74000000000000;0.800000000000000;];
PYRObs=[0.0100000000000000;0.0100000000000000;0.0100000000000000;0.0400000000000000;0.130000000000000;0.250000000000000;0.330000000000000;0.570000000000000;0.460000000000000;1.15000000000000;2.06000000000000;2.91000000000000;4.12000000000000;3.27000000000000;1.75000000000000;0;0;0.0100000000000000;0.0100000000000000;0.0100000000000000;0.0100000000000000;0.0500000000000000;0.200000000000000;0.300000000000000;0.620000000000000;0.830000000000000;0.990000000000000;1.62000000000000;2.59000000000000;3.56000000000000;3.20000000000000;1.96000000000000;1.57000000000000;0.0200000000000000;0;0;0.0100000000000000;0.0200000000000000;0.0100000000000000;0.0300000000000000;0.110000000000000;0.200000000000000;0.250000000000000;0.540000000000000;1.20000000000000;1.30000000000000;1.88000000000000;2.91000000000000;4.12000000000000;3.27000000000000;0;0;0;0;];

X_AVG=[0.000500000000000000;0.0193333330000000;0.0346666670000000;0.0316666670000000;0.0470000000000000;0.0960000000000000;0.112333333000000;0.130666667000000;0.153333333000000;0.160666667000000;0.192000000000000;0.257666667000000;0.330000000000000;0.359333333000000;0.410666667000000;0.514000000000000;0.520666667000000;0.532666667000000;];
LACT_AVG=[29.6433333300000;27.5033333300000;26.7900000000000;25.2400000000000;23.6933333300000;22.1066666700000;20.2766666700000;19.7633333300000;18.6666666700000;15.3266666700000;12.0933333300000;6.52000000000000;1.75333333300000;0.110000000000000;0.0866666670000000;0.0466666670000000;0.0400000000000000;0.0233333330000000;];
ACT_AVG=[0.0166666670000000;0.273333333000000;0.496666667000000;0.826666667000000;1.27333333300000;1.18333333300000;1.39333333300000;1.90000000000000;2.26333333300000;2.91666666700000;3.76000000000000;5.37666666700000;6.77666666700000;7.55333333300000;7.35000000000000;5.62333333300000;2.54666666700000;0.596666667000000;];
PYR_AVG=[0.0100000000000000;0.0133333330000000;0.0100000000000000;0.0400000000000000;0.146666667000000;0.250000000000000;0.400000000000000;0.646666667000000;0.883333333000000;1.35666666700000;2.17666666700000;3.12666666700000;3.81333333300000;2.83333333300000;1.10666666700000;0.00666666700000000;0;0.00333333300000000;];

%Monod equations
global y0;
y0=[0.00045738 29.64 0.02 0.01];
t=[0;11;13;15;17;18;19;20;21;22;23.5000000000000;25;26.5000000000000;28;29.5000000000000;31;32.5000000000000;34;];
tspan=t; %we want y at every t

       global umax_L;
       global umax_A;
       global umax_P;
       global Ksl;
       global Ksa;
       global Ksp;
       global kpl;
       global kal;
       global kap;
       global Yxl;
       global Yxa;
       global Yxp;
       global ke;
       global tL;

       
       umax_L=var(1);
       umax_A=var(2);
       umax_P=var(3);
       Ksl=var(4);
       Ksa=var(5);
       Ksp=var(6);
       kpl=var(7);
       kal=var(8);
       kap=var(9);
       ke=var(10);
       tL=var(11);
       Yxl=var(12);
       Yxa=var(13);
       Yxp=var(14);
    
[t,y]=ode23(@monod_final,tspan,y0);

Xsim_all=[y(:,1);y(:,1);y(:,1)];
LACTsim_all=[y(:,2);y(:,2);y(:,2)];
ACTsim_all=[y(:,3);y(:,3);y(:,3)];
PYRsim_all=[y(:,4);y(:,4);y(:,4)];

error_X=sum(((Xsim_all-XObs)./max(XObs)).^2);
error_LACT=sum(((LACTsim_all-LACTObs)./max(LACTObs)).^2);
error_ACT=sum(((ACTsim_all-ACTObs)./max(ACTObs)).^2);
error_PYR=sum(((PYRsim_all-PYRObs)./max(PYRObs)).^2);

f=error_X+error_LACT+error_ACT+error_PYR;






      





